/*#ifdef SKINNING

	#version 120
	#extension EXT_gpu_shader4 : enable          

#endif*/

//#ifdef _HEIGHTMAP_
#ifdef _VERSION_CHECK_
	#ifndef _NOT_INSTANCED_

		#version 120
		#extension EXT_gpu_shader4 : enable          

	#endif
#endif
//#endif

#ifdef SKINNING

//uniform mat3 	boneMatrices[100];
uniform samplerBuffer 	boneMatrices;
//attribute vec4  weights;
//attribute vec4  matrixIndices;

#endif

#ifdef _HEIGHTMAP_
	
	uniform sampler2D	heightmap;
	uniform vec2		invHeightmapSize;
	uniform vec2		tileDim;
	uniform vec3		invTerrainDim;
	//uniform vec3		tilePos;	// tilepos
	uniform vec3		terrainDim; // width, depth and height of the terrain
 	uniform vec3		WorldPoses[200];
	varying vec2 		texcoord2;
	
#else
	#ifndef _NOT_INSTANCED_
		uniform samplerBuffer	WorldPoses;
	#endif
	//varying float	alphaFade;
	//uniform float 	fade;
#endif
 
varying vec2 	texcoord;
uniform vec2	tscale0;
uniform vec4 	plane;
varying float 	dist;
uniform mat4	prevWTM;

uniform vec3	ldir;
uniform vec4 	diffuseColor;	// material color * sun color * sun power
varying vec4	diffuse;

//attribute vec3 	normal;

// FOG UNIFORMS
uniform vec3  	campos;
varying vec4 	fog;
uniform vec3 	fogColor;
uniform float 	extintion;
/////////////////////

varying vec4	eyepos;

float ComputeVolumetricFog( vec3 cameraToWorldPos )
{
	float fogInt;
	fogInt=length( cameraToWorldPos )*0.5;		
	return exp( -extintion * (fogInt) );
}

float ComputeScatter( vec3 wpos, vec3 cameraToWorldPos )
{
	float L=0.0;
	float Y=plane.w-campos.y;
	vec3 dir=vec3(0.0,0.0,0.0);
	
	if(Y <= 0.0)
		Y=0.0;
	
	if(wpos.y>plane.w )
		L=(length( cameraToWorldPos ) * Y) / cameraToWorldPos.y; 
	else
		L=length( cameraToWorldPos );
			
	if(L>0.0)
		dir=normalize(cameraToWorldPos);
		
	return exp( -extintion * Y * 0.1 ) * ( ( exp((dir.y-1.0)*extintion*L) - 1.0 ) / ((dir.y-1.0) * extintion)) * 0.01;
}

void main()
{
	vec3 viewDir;
	vec4 normal4 = vec4( gl_Normal.xyz, 0.0 );
	
#ifdef _HEIGHTMAP_

	// compute position basing on heightmap
	vec4 	position00 = gl_Vertex,
			position10 = gl_Vertex,
			position01 = gl_Vertex;
	vec4 tempNormal = vec4( 0.0, 0.0, 0.0, 0.0 );
	mat4 TM;
		
	vec3 tilepos=WorldPoses[gl_InstanceID];
	texcoord = ((gl_Vertex.xz + tilepos.xz)*invTerrainDim.xz)+vec2(0.5,0.5)+(invHeightmapSize*0.5);
	texcoord2 = texcoord;
	
	position00.y=(texture2D(heightmap,texcoord.st).x-0.5)*terrainDim.y;
	position00.xz=gl_Vertex.xz;
	position10.y=(texture2D(heightmap,texcoord.st + vec2(invHeightmapSize.x,0.0)).x-0.5)*terrainDim.y;
	position10.xz=gl_Vertex.xz + vec2(tileDim.x,0.0);
	position01.y=(texture2D(heightmap,texcoord.st + vec2(0.0,invHeightmapSize.y)).x-0.5)*terrainDim.y;
	position01.xz=gl_Vertex.xz + vec2(0.0,tileDim.y);
	
	vec4 position;
	position.xyz=tilepos+position00.xyz;
	position.w=1.0;
	
	// transform position in projection and eye space
	eyepos = gl_ModelViewMatrix * position;
	gl_Position = gl_ProjectionMatrix * eyepos;
		
	// compute normals (convert heightmap into normalmap
	vec3 t0,t1;
	t0=normalize(position00.xyz-position10.xyz);
	t1=normalize(position00.xyz-position01.xyz);
	tempNormal.xyz=cross(t1,t0);
	
	dist=(position.y*plane.y)+plane.w;

	diffuse = diffuseColor*max(dot(ldir,/*vnormal*/tempNormal.xyz),0.0);
	texcoord *= tscale0;
	
	// compute view direction
	viewDir=campos-position.xyz;
	fog.a=ComputeVolumetricFog(-viewDir);
	float scatter=ComputeScatter( position.xyz, -viewDir );
	fog.rgb=fogColor*scatter;

#else

	texcoord = gl_MultiTexCoord0.st*tscale0;
	
	#ifdef SKINNING

		vec4 position = vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 tempNormal = vec4( 0.0, 0.0, 0.0, 0.0 );
		mat4 TM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);
					
				int j;
				
				j=int(gl_SecondaryColor.x/*matrixIndices.x*/)*4;
				TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
				TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
				TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
				TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
		position = position + ((TM * gl_Vertex) * /*weights.x*/gl_Color.x);
		TM[3]=vec4(0,0,0,1);
		tempNormal=tempNormal + ((TM * normal4) * /*weights.x*/gl_Color.x);
		
				j=int(gl_SecondaryColor.y/*matrixIndices.y*/)*4;
				TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
				TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
				TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
				TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
		position = position + ((TM * gl_Vertex) * /*weights.y*/gl_Color.y);
		TM[3]=vec4(0,0,0,1);
		tempNormal=tempNormal + ((TM * normal4) * /*weights.y*/gl_Color.y);
				
				j=int(gl_SecondaryColor.z/*matrixIndices.z*/)*4;
				TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
				TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
				TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
				TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
		position = position + ((TM * gl_Vertex) * /*weights.z*/gl_Color.z);
		TM[3]=vec4(0,0,0,1);
		tempNormal=tempNormal + ((TM * normal4) * /*weights.z*/gl_Color.z);

				j=int(gl_SecondaryColor.w/*matrixIndices.w*/)*4;
				TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
				TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
				TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
				TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
		position = position + ((TM * gl_Vertex) * /*weights.w*/gl_Color.w);
		TM[3]=vec4(0,0,0,1);
		tempNormal=tempNormal + ((TM * normal4) * /*weights.w*/gl_Color.w);
		
		gl_Position = gl_ModelViewProjectionMatrix * position;
		
		TM=prevWTM;
		vec4 vert=TM*position;
		dist=(vert.y*plane.y)+plane.w;

		TM[3]=vec4(0,0,0,1);
		vec4 vnormal=TM*tempNormal;
		
		diffuse = diffuseColor*max(dot(ldir,vnormal.xyz),0.0);
		
		// compute view direction
		viewDir=campos-vert.xyz;
		fog.a=ComputeVolumetricFog(-viewDir);
		float scatter=ComputeScatter( vert.xyz, -viewDir );
		fog.rgb=fogColor*scatter;
		
		eyepos=gl_ModelViewMatrix*position;
		
	#else
		
		vec4 vert;
		#ifndef _NOT_INSTANCED_
			mat4 TM;
			int index=gl_InstanceID*4;
			TM[0]=texelFetchBuffer(WorldPoses,index);
			TM[1]=texelFetchBuffer(WorldPoses,index+1);
			TM[2]=texelFetchBuffer(WorldPoses,index+2);
			TM[3]=texelFetchBuffer(WorldPoses,index+3);
			//alphaFade=TM[3].w+0.01;
			TM[1].w=0.0;				
			TM[2].w=0.0;
			TM[3].w=1.0;
			
			vert=TM*gl_Vertex;	
			eyepos=gl_ModelViewMatrix*vert;
			gl_Position = gl_ProjectionMatrix*eyepos;//ftransform();
		#else
			mat4 TM=prevWTM;
			eyepos=gl_ModelViewMatrix*gl_Vertex;
			gl_Position = (gl_ProjectionMatrix)*eyepos;//ftransform();
			vert=TM*gl_Vertex;	
		#endif
		
		//TM[3]=vec4(0,0,0,1);
		vec4 vnormal=TM*normal4;
		diffuse = diffuseColor*max(dot(ldir,vnormal.xyz),0.0);
		dist=(vert.y*plane.y)+plane.w;

		// compute view direction
		viewDir=campos-vert.xyz;
		fog.a=ComputeVolumetricFog(-viewDir);
		float scatter=ComputeScatter( vert.xyz, -viewDir );
		fog.rgb=fogColor*scatter;
			
	#endif
	
#endif

}